/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.preferencesdialog;

import java.awt.Font;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.nooj4nlp.controller.preferencesdialog.SelectDefLanguageActionListener;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.gui.dialogs.PreferencesDialog;
import net.nooj4nlp.gui.main.Launcher;

public class UpdateDialogListener {
    private JComboBox cbDefLanguage;
    private Font TFont;
    private Font DFont;
    private JLabel fText;
    private JLabel fDic;
    private JCheckBox chckbxNoojManagesMultiple;
    private PreferencesDialog dialog;

    public UpdateDialogListener(PreferencesDialog dialog, JComboBox cbDefLanguage, Font TFont, Font DFont, JLabel fText, JLabel fDic) {
        this.cbDefLanguage = cbDefLanguage;
        this.TFont = TFont;
        this.DFont = DFont;
        this.fDic = fDic;
        this.fText = fText;
        this.dialog = dialog;
    }

    public void updateFromFormMainPreferences() {
        this.cbDefLanguage.removeAllItems();
        if (Launcher.preferences.deflanguage == null) {
            return;
        }
        if (Launcher.projectMode) {
            for (String lan : Launcher.preferences.languages) {
                this.cbDefLanguage.addItem(lan);
            }
            this.cbDefLanguage.setSelectedIndex(0);
        } else {
            SelectDefLanguageActionListener selectDefLangListener = this.dialog.getSelectDefLanguageListener();
            this.cbDefLanguage.removeActionListener(selectDefLangListener);
            for (String lan : Language.getAllLanguages()) {
                this.cbDefLanguage.addItem(lan);
            }
            this.cbDefLanguage.addActionListener(selectDefLangListener);
            int index = -1;
            for (int i = 0; i < this.cbDefLanguage.getItemCount(); ++i) {
                if (!Launcher.preferences.deflanguage.equalsIgnoreCase((String)this.cbDefLanguage.getItemAt(i))) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.cbDefLanguage.setSelectedIndex(index);
            }
        }
        Font f = Launcher.preferences.TFont;
        this.TFont = new Font(f.getName(), f.getStyle(), f.getSize());
        this.fText.setText(this.TFont.getName() + ", " + this.TFont.getSize());
        if (this.TFont.isBold()) {
            this.fText.setText(this.fText.getText() + ", Bold");
        }
        if (this.TFont.isItalic()) {
            this.fText.setText(this.fText.getText() + ", Italic");
        }
        f = Launcher.preferences.DFont;
        this.DFont = new Font(f.getName(), f.getStyle(), f.getSize());
        this.fDic.setText(this.DFont.getName() + ", " + this.DFont.getSize());
        if (this.DFont.isBold()) {
            this.fDic.setText(this.fDic.getText() + ", Bold");
        }
        if (this.DFont.isItalic()) {
            this.fDic.setText(this.fDic.getText() + ", Italic");
        }
    }
}

